package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.EmpresaServicioPrevencionDao;
import com.ejie.ab04b.model.EmpresaServicioPrevencion;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0480s00ServiceImpl generated by UDA, 19-Jan-2017 11:07:18.
 * 
 * @author UDA
 */

@Service(value = "ab0480s00Service")
public class EmpresaServicioPrevencionServiceImpl implements EmpresaServicioPrevencionService {

	@Autowired()
	private EmpresaServicioPrevencionDao ab0480s00Dao;

	/**
	 * Inserts a single row in the Ab0480s00 table.
	 * 
	 *  ab0480s00
	 *            Ab0480s00
	 *  Ab0480s00
	 *
	 * @param ab0480s00 the ab 0480 s 00
	 * @return the empresa servicio prevencion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EmpresaServicioPrevencion add(EmpresaServicioPrevencion ab0480s00) {
		return this.ab0480s00Dao.add(ab0480s00);
	}

	/**
	 * Updates a single row in the Ab0480s00 table.
	 * 
	 *  ab0480s00
	 *            Ab0480s00
	 *  Ab0480s00
	 *
	 * @param ab0480s00 the ab 0480 s 00
	 * @return the empresa servicio prevencion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EmpresaServicioPrevencion update(EmpresaServicioPrevencion ab0480s00) {
		return this.ab0480s00Dao.update(ab0480s00);
	}

	/**
	 * Finds a single row in the Ab0480s00 table.
	 * 
	 *  ab0480s00
	 *            Ab0480s00
	 *  Ab0480s00
	 *
	 * @param ab0480s00 the ab 0480 s 00
	 * @return the empresa servicio prevencion
	 */
	public EmpresaServicioPrevencion find(EmpresaServicioPrevencion ab0480s00) {
		return (EmpresaServicioPrevencion) this.ab0480s00Dao.find(ab0480s00);
	}

	/**
	 * Deletes a single row in the Ab0480s00 table.
	 * 
	 *  ab0480s00
	 *            Ab0480s00
	 *
	 * @param ab0480s00 the ab 0480 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(EmpresaServicioPrevencion ab0480s00) {
		this.ab0480s00Dao.remove(ab0480s00);
	}

	/**
	 * Finds a list of rows in the Ab0480s00 table.
	 * 
	 *  ab0480s00
	 *            Ab0480s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0480s00>
	 *
	 * @param ab0480s00 the ab 0480 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<EmpresaServicioPrevencion> findAll(EmpresaServicioPrevencion ab0480s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<EmpresaServicioPrevencion>) this.ab0480s00Dao.findAll(ab0480s00, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0480s00 table using like.
	 * 
	 *  ab0480s00
	 *            Ab0480s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0480s00>
	 *
	 * @param ab0480s00 the ab 0480 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<EmpresaServicioPrevencion> findAllLike(EmpresaServicioPrevencion ab0480s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<EmpresaServicioPrevencion>) this.ab0480s00Dao.findAllLike(ab0480s00, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab0480s00 table.
	 * 
	 *  filterAb0480s00
	 *            Ab0480s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterAb0480s00 the filter ab 0480 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(EmpresaServicioPrevencion filterAb0480s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		this.ab0480s00Dao.removeMultiple(filterAb0480s00, jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the Ab0480s00 table.
	 * 
	 *  filterAb0480s00
	 *            Ab0480s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0480s00>
	 *
	 * @param filterAb0480s00 the filter ab 0480 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<EmpresaServicioPrevencion> filter(EmpresaServicioPrevencion filterAb0480s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<EmpresaServicioPrevencion> listaAb0480s00 = this.ab0480s00Dao.findAllLike(filterAb0480s00,
				jqGridRequestDto, false);
		Long recordNum = this.ab0480s00Dao
				.findAllLikeCount(filterAb0480s00 != null ? filterAb0480s00 : new EmpresaServicioPrevencion(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<EmpresaServicioPrevencion>> reorderSelection = this.ab0480s00Dao
					.reorderSelection(filterAb0480s00, jqGridRequestDto, startsWith);
			return new JQGridResponseDto<EmpresaServicioPrevencion>(jqGridRequestDto, recordNum, listaAb0480s00,
					reorderSelection);
		}
		return new JQGridResponseDto<EmpresaServicioPrevencion>(jqGridRequestDto, recordNum, listaAb0480s00);
	}

	/**
	 * Searches rows in the Ab0480s00 table.
	 * 
	 *  filterAb0480s00
	 *            Ab0480s00
	 *  searchAb0480s00
	 *            Ab0480s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0480s00>>
	 *
	 * @param filterAb0480s00 the filter ab 0480 s 00
	 * @param searchAb0480s00 the search ab 0480 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<EmpresaServicioPrevencion>> search(EmpresaServicioPrevencion filterAb0480s00,
			EmpresaServicioPrevencion searchAb0480s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0480s00Dao.search(filterAb0480s00, searchAb0480s00, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0480s00 table.
	 * 
	 *  filterAb0480s00
	 *            Ab0480s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0480s00 the filter ab 0480 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(EmpresaServicioPrevencion filterAb0480s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.ab0480s00Dao.reorderSelection(filterAb0480s00, jqGridRequestDto, startsWith);
	}

}
